<?php

namespace App\Notifications;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\URL; // 💡 برای ساخت URL امن

class AccountActivationRequest extends Notification
{
    use Queueable;

    protected $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * کانال‌هایی که نوتیفیکیشن باید از طریق آنها ارسال شود.
     */
    public function via(object $notifiable): array
    {
        // 💡 ابتدا فقط database را نگه می‌داریم تا مطمئن شویم کار می‌کند، سپس mail را اضافه می‌کنیم.
        return ['database', 'mail'];
    }

    /**
     * دریافت نمایش Notification برای کانال ایمیل.
     */
//    public function toMail(object $notifiable): MailMessage
//    {
//        // 💡 استفاده از URL::route یا URL::to برای اطمینان از تعریف آدرس
//        $activationUrl = URL::to('/admin/users/' . $this->user->id . '/edit');
//
//        return (new MailMessage)
//            ->subject('🔔 درخواست فعال‌سازی حساب کاربری')
//            ->greeting('درخواست فعال‌سازی حساب جدید')
//            ->line('کاربر **' . $this->user->name . '** (ایمیل: ' . $this->user->email . ') درخواست فعال‌سازی حساب کاربری خود را ارسال کرده است.')
//            ->action('فعال‌سازی و مدیریت کاربران', $activationUrl)
//            ->line('لطفاً در اسرع وقت اقدام به بررسی و فعال‌سازی این حساب نمایید.');
//    }
    public function toMail(object $notifiable): MailMessage
    {
        // 🔐 فقط اگر route تعریف شده باشد و کاربر مدیر باشد (در ایمیل فقط لینک دسترسی داده نمی‌شود!)
        // ✅ بهتر است فقط به پنل مدیریت (لیست کاربران) لینک داده شود، نه مستقیماً edit!
        $adminUsersUrl = URL::route('admin.users.index', [], true); // force absolute

        return (new MailMessage)
            ->subject('🔔 درخواست فعال‌سازی حساب کاربری')
            ->greeting('درخواست فعال‌سازی جدید')
            ->line("کاربر **{$this->user->name}** (ایمیل: {$this->user->email}) درخواست فعال‌سازی ارسال کرده است.")
            ->action('مشاهده لیست کاربران', $adminUsersUrl)
            ->line('لطفاً وارد پنل مدیریت شوید و وضعیت این کاربر را بررسی کنید.');
    }
    /**
     * دریافت نمایش Notification برای کانال دیتابیس (با نام صحیح).
     */
    public function toDatabase(object $notifiable): array
    {
        // 💡 برای استفاده در NotificationsDropdown، بهتر است URL را هم اضافه کنیم.
        return [
            'user_id' => $this->user->id,
            'user_name' => $this->user->name,
            'message' => 'درخواست فعال‌سازی حساب توسط ' . $this->user->name,
            'type' => 'activation_request',
            // مسیردهی به صفحه مدیریت کاربر
            'url' => route('admin.users.show', $this->user->id),
        ];
    }
}
