<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Contracts\Queue\ShouldQueue;

class AnnouncementNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $title;
    public $content;
    public $isPublic;
    public $projectId;

    public function __construct($title, $content, $isPublic = true, $projectId = null)
    {
        $this->title = $title;
        $this->content = $content;
        $this->isPublic = $isPublic;
        $this->projectId = $projectId;
    }

    public function via($notifiable)
    {
        return ['database', 'broadcast']; // ذخیره در دیتابیس برای seen و پخش واقعی‌زمان
    }

    public function toArray($notifiable)
    {
        return [
            'title' => $this->title,
            'content' => $this->content,
            'is_public' => $this->isPublic,
            'project_id' => $this->projectId,
        ];
    }

    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage($this->toArray($notifiable));
    }
}
