<?php
namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class DeadlineReminder extends Notification
{
    use Queueable;

    protected $type, $date, $projectName, $projectId;

    public function __construct($type, $date, $projectName, $projectId)
    {
        $this->type = $type;
        $this->date = $date;
        $this->projectName = $projectName;
        $this->projectId = $projectId;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject("یادآوری مهلت {$this->type}")
            ->line("مهلت {$this->type} برای پروژه {$this->projectName} در تاریخ " . jdate($this->date)->format('Y/m/d') . " به پایان می‌رسد.")
            ->action('مشاهده پروژه', route('projects.show', $this->projectId))
            ->line('لطفاً اقدامات لازم را انجام دهید.');
    }

    public function toArray($notifiable)
    {
        return [
            'type' => $this->type,
            'date' => $this->date->toDateString(),
            'project_name' => $this->projectName,
            'project_id' => $this->projectId,
        ];
    }
}
