<?php

namespace App\Notifications;

use App\Models\PettyCash;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Messages\DatabaseMessage;

class PettyCashNeedsApproval extends Notification
{
    use Queueable;

    public function __construct(public PettyCash $request) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    public function toDatabase(object $notifiable): array
    {
        return [
            'petty_cash_id' => $this->request->id,
            'requester_id' => $this->request->user_id,
            'requester_name' => $this->request->user->name,
            'amount' => $this->request->amount,
            'reason' => $this->request->reason,
            'status' => $this->request->status,
            'message' => "درخواست هزینه جزء جدیدی از «{$this->request->user->name}» با مبلغ " . number_format($this->request->amount) . " تومان نیاز به تأیید شما دارد.",
            'url' => route('admin.petty-cash.index'),
            'icon' => 'wallet',
            'color' => 'primary',
            'timestamp' => now()->toISOString(),
        ];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('نیاز به تأیید درخواست هزینه جزء')
            ->greeting('سلام ' . $notifiable->name)
            ->line('درخواست هزینه جزء جدیدی نیاز به بررسی و تأیید شما دارد.')
            ->line('**درخواست‌دهنده:** ' . $this->request->user->name)
            ->line('**مبلغ:** ' . number_format($this->request->amount) . ' تومان')
            ->line('**دلیل:** ' . $this->request->reason)
            ->action('مشاهده و تأیید درخواست‌ها', route('admin.petty-cash.index'))
            ->line('با تشکر از همکاری شما.')
            ->salutation('با احترام،<br>تیم مدیریت سیستم');
    }
}
