<?php

namespace App\Notifications;

use App\Models\PurchaseRequest;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;

class PurchaseRequestCreated extends Notification
{
    use Queueable;

    protected $purchaseRequest;

    /**
     * ایجاد یک نمونه جدید از اعلان
     */
    public function __construct(PurchaseRequest $purchaseRequest)
    {
        // لود کردن روابط مورد نیاز برای جلوگیری از خطای دیتابیس در زمان ارسال
        $this->purchaseRequest = $purchaseRequest->load(['user', 'project', 'items']);
    }

    /**
     * تعیین کانال‌های ارسال (فقط دیتابیس)
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * ذخیره اطلاعات در جدول notifications برای نمایش هوشمند در زنگوله
     */
    public function toArray(object $notifiable): array
    {
        // محاسبه مبلغ کل درخواست
        $totalAmount = $this->purchaseRequest->items->sum(function($item) {
            return $item->quantity * $item->price;
        });

        return [
            'id' => $this->purchaseRequest->id, // آیدی درخواست برای دسترسی سریع
            'title' => 'درخواست خرید جدید',
            'message' => "درخواست PR-{$this->purchaseRequest->id} برای پروژه {$this->purchaseRequest->project->name} ثبت گردید.",
            'sender' => $this->purchaseRequest->user->name ?? 'سیستم',

            // این فیلدها برای استایل‌دهی در دراپ‌داون زنگوله ضروری هستند:
            'url' => route('admin.purchase_request'),
            'icon' => 'ti ti-shopping-cart',
            'color' => 'indigo', // رنگ نیلی مخصوص تدارکات
            'type' => 'purchase_request',

            // اطلاعات تکمیلی (اختیاری)
            'meta' => [
                'project' => $this->purchaseRequest->project->name,
                'amount' => number_format($totalAmount) . ' ریال',
                'description' => $this->purchaseRequest->description
            ]
        ];
    }
}
