<?php

namespace App\Policies;

use App\Models\LeaveMissionRequest as LMR;
use App\Models\User;

class LeaveMissionRequestPolicy
{
    public function approve(User $user, LMR $req): bool
    {
        $cur = $req->currentApproval();
        if (!$cur) return false;
        return in_array($user->id, array_filter([$cur->approver_id, $cur->delegated_to]));
    }
}
