<?php

namespace App\Providers;

use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Gate; // 💡 باید اضافه شود
use App\Models\User; // 💡 باید اضافه شود
use App\Models\Project; // برای استفاده در صورت نیاز به چک کردن پروژه در آینده

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);

        // 🛑 ۱. Gate اصلی ادمین (Admin Bypass)
        // این Gate بالاترین سطح دسترسی را برای ادمین اصلی فراهم می‌کند.
        Gate::define('is-admin', function (User $user) {
            return $user->role === 'admin';
        });

        // 🛑 ۲. Gate مدیریت کاربران و ساختار سازمانی (Management)
        // این مجوز برای مدیریت User, Roles, Company, Department و سایر ساختارهای هسته استفاده می‌شود.
        Gate::define('manage-structure', function (User $user) {
            return $user->role === 'admin';
        });

        // 🛑 ۳. Gate مدیریت جایگاه‌های سازمانی (User Positions)
        Gate::define('manage-positions', function (User $user) {
            // فرض می‌کنیم ادمین و HR می‌توانند جایگاه‌ها را مدیریت کنند.
            return $user->role === 'admin' || $user->role === 'hr_manager';
        });

        // 🛑 ۴. Gate مدیریت پروژه (برای ثبت، حذف، و تنظیمات اصلی پروژه)
        Gate::define('manage-projects', function (User $user) {
            return $user->role === 'admin' || $user->role === 'project_manager';
        });

        // 💡 Gate Before: ادمین اصلی از تمام پالیسی‌ها و Gateهای تعریف شده عبور می‌کند.
        Gate::before(function (User $user, string $ability) {
            if ($user->role === 'admin') {
                return true;
            }
        });
    }

}
