<?php

// bootstrap/app.php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        channels: __DIR__.'/../routes/channels.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
// استثنا کردن مسیر آپلود لایوایر از CSRF
        $middleware->validateCsrfTokens(except: [
            'livewire/upload-file',
        ]);

        // **افزودن CheckUserStatus به انتهای گروه 'web'**
        $middleware->web(append: [
            \App\Http\Middleware\CheckUserStatus::class,
        ]);

        // یا اگر نیاز دارید قبل از Middleware های خاصی اجرا شود:
        // $middleware->web(prepend: [
        //     \App\Http\Middleware\CheckUserStatus::class,
        // ]);

    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
