<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('project_id');
            $table->unsignedBigInteger('manager_id');
            $table->foreign('project_id')->references('id')->on('projects')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('manager_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->string('project_code');
            $table->string('tax_code');
            $table->unsignedBigInteger('main_client_id'); //کارفرمای اصلی
            $table->unsignedBigInteger('contractor_id')->nullable();  //پیمانکار
            $table->unsignedBigInteger('sub_client_id')->nullable();
            $table->foreign('main_client_id')->references('id')->on('Companies')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('contractor_id')->references('id')->on('Companies')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('sub_client_id')->references('id')->on('Companies')->onDelete('cascade')->onUpdate('cascade');
            $table->string('status');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_details');
    }
};
