<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('section_files', function (Blueprint $table) {
            $table->id();

            // اطلاعات اصلی فایل
            $table->string('name', 255); // نام نمایشی فایل
            $table->string('path', 512); // مسیر ذخیره فایل
            $table->string('original_name', 255); // نام اصلی فایل
            $table->string('mime_type', 100); // نوع MIME فایل
            $table->unsignedBigInteger('size'); // حجم فایل به بایت

            // روابط خارجی
            $table->foreignId('project_id')
                ->constrained('projects')
                ->cascadeOnDelete();

            $table->foreignId('section_id')
                ->constrained('sections')
                ->cascadeOnDelete();

            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete();

            // زمان‌بندی
            $table->timestamps();
            $table->softDeletes(); // حذف نرم

            // ایندکس‌های بهینه
            $table->index(['project_id', 'section_id']);
            $table->index(['mime_type', 'created_at']);
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('section_files');
    }
};
