<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

    public function up()
    {
        Schema::table('project_files', function (Blueprint $table) {
            $table->unsignedBigInteger('folder_id')->nullable()->after('section_id');

            // اگر می‌خواهید کلید خارجی تعریف کنید (اختیاری)
            $table->foreign('folder_id')->references('id')->on('folders')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('project_files', function (Blueprint $table) {
            $table->dropForeign(['folder_id']);
            $table->dropColumn('folder_id');
        });
    }
};
