<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMasterDocumentsTable extends Migration
{
    public function up()
    {
        Schema::create('master_documents', function (Blueprint $table) {
            $table->id();  // شناسه یکتا برای هر مستند
            $table->foreignId('project_id')->constrained()->onDelete('cascade'); // ارتباط با جدول پروژه
            $table->foreignId('category_id')->nullable()->constrained('document_categories')->onDelete('set null'); // ارتباط با دسته‌بندی
            $table->string('document_number'); // شماره سند
            $table->string('title'); // عنوان سند
            $table->foreignId('discipline_id')->nullable()->constrained('disciplines')->onDelete('set null'); // ارتباط با دیسپلین
            $table->string('document_type')->nullable(); // نوع سند
            $table->string('revision')->nullable(); // شماره نسخه (مانند Rev.01)
            $table->string('last_revision')->nullable(); // آخرین نسخه
            $table->enum('status', ['در حال تهیه', 'ارسال شده', 'تایید شده', 'رد شده'])->nullable(); // وضعیت سند
            $table->date('planned_issue_date')->nullable(); // تاریخ برنامه‌ریزی شده برای انتشار
            $table->date('actual_issue_date')->nullable(); // تاریخ انتشار واقعی
            $table->text('description')->nullable(); // توضیحات
            $table->string('person_hour')->nullable(); // نفرساعت
            $table->string('wf')->nullable(); // وزن پیشرفت
            $table->string('progress_percent')->nullable(); // درصد پیشرفت
            $table->string('approval_status')->nullable(); // وضعیت تایید
            $table->string('remark')->nullable(); // یادداشت
            $table->timestamps(); // زمان‌های ایجاد و بروزرسانی
        });
    }

    public function down()
    {
        Schema::dropIfExists('master_documents');
    }
}
