<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('document_revisions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('master_document_id')->constrained()->onDelete('cascade');
            $table->string('revision_type')->nullable();
            $table->string('transmittal_number')->nullable();
            $table->string('revision')->nullable();
            $table->string('status')->nullable();
            $table->date('date')->nullable();
            $table->string('remark')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('document_revisions');
    }
};
