<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransmittalDocumentsTable extends Migration
{
    public function up()
    {
        Schema::create('transmittal_documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('transmittal_id');
            $table->unsignedBigInteger('master_document_id');
            $table->unsignedBigInteger('revision_id')->nullable();
            $table->string('revision')->nullable();
            $table->string('description')->nullable();
            $table->timestamps();

            $table->foreign('transmittal_id')->references('id')->on('transmittals')->onDelete('cascade');
            $table->foreign('master_document_id')->references('id')->on('master_documents')->onDelete('cascade');
            $table->foreign('revision_id')->references('id')->on('document_revisions')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('transmittal_documents');
    }
}
