<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

    public function up()
    {
        Schema::create('transmittal_attachments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('transmittal_id')->constrained()->onDelete('cascade');
            $table->string('file_name');
            $table->string('file_path');
            $table->unsignedBigInteger('size'); // اندازه به بایت
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('transmittal_attachments');
    }
};
