<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('transmittal_recipients', function (Blueprint $table) {
            $table->id();
            $table->foreignId('transmittal_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('role')->default('to'); // to, cc, bcc
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('transmittal_recipients');
    }
};
