<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLetterUserTable extends Migration
{
    public function up()
    {
        Schema::create('letter_user', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('letter_id');
            $table->unsignedBigInteger('user_id');
            $table->timestamp('read_at')->nullable();
            $table->boolean('is_read')->default(0); // اختیاری برای وضعیت خواندن
            $table->timestamps();

            // کلیدهای خارجی
            $table->foreign('letter_id')->references('id')->on('letters')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            // ترکیب یکتا برای جلوگیری از دوباره ثبت شدن
            $table->unique(['letter_id', 'user_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('letter_user');
    }
}
