<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactsTable extends Migration
{
    public function up()
    {
        Schema::create('contacts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('phone_number')->nullable();
            $table->string('fax_number')->nullable();
            $table->string('email')->nullable();
            $table->string('address')->nullable();
            $table->string('phone_type')->nullable();
            $table->boolean('is_public')->default(false);  // آیا عمومی است؟
            $table->unsignedBigInteger('created_by');  // شناسه کاربری که این مخاطب را ذخیره کرده
            $table->unsignedBigInteger('group_id')->nullable();  // گروه مخاطب
            $table->timestamps();

            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('group_id')->references('id')->on('contact_groups')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('contacts');
    }
}
