<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('departments', function (Blueprint $table) {
            $table->foreignId('parent_id')->nullable()->constrained('departments')->nullOnDelete();
            $table->foreignId('manager_id')->nullable()->constrained('users')->nullOnDelete();
            $table->string('code')->nullable(); // کد کوتاه مثل HR, FIN, SALES
            $table->enum('status', ['active','inactive'])->default('active');
            $table->string('color', 16)->nullable(); // مثل #0ea5e9
            $table->unsignedSmallInteger('sort_order')->default(0);
            $table->text('description')->nullable();

            // یونیک ترکیبی کد در هر شرکت
            $table->unique(['company_id','code']);
            // ایندکس‌های مفید
            $table->index(['company_id','parent_id']);
            $table->index(['company_id','status']);
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('departments', function (Blueprint $table) {
            //
        });
    }
};
