<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('leave_mission_requests', function (Blueprint $t) {
            $t->id();
            $t->foreignId('user_id')->constrained()->cascadeOnDelete();
            $t->foreignId('company_id')->nullable()->constrained()->nullOnDelete();
            $t->foreignId('department_id')->nullable()->constrained()->nullOnDelete();

            $t->enum('type', ['leave','mission']);
            $t->enum('status', ['draft','pending','approved','rejected','canceled'])->default('draft');
            $t->unsignedTinyInteger('current_step')->default(0);

            $t->string('title')->nullable();
            $t->text('description')->nullable();
            $t->unsignedSmallInteger('attachments_count')->default(0);

            $t->timestamp('submitted_at')->nullable();
            $t->timestamp('decided_at')->nullable();
            $t->timestamps();

            $t->index(['type','status']);
            $t->index(['department_id','status']);
            $t->index(['user_id','submitted_at']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('leave_mission_requests');
    }
};
