<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('leave_mission_details', function (Blueprint $t) {
            $t->id();
            $t->foreignId('request_id')->unique()->constrained('leave_mission_requests')->cascadeOnDelete();

            // مرخصی
            $t->enum('leave_type', ['annual','sick','unpaid','overtime_comp','other'])->nullable();

            // ماموریت
            $t->string('mission_city',120)->nullable();
            $t->string('mission_address',255)->nullable();
            $t->string('mission_purpose',255)->nullable();

            // بازه زمانی مشترک
            $t->timestamp('start_datetime');
            $t->timestamp('end_datetime');

            $t->unsignedMediumInteger('duration_hours');
            $t->boolean('is_full_day')->default(true);
            $t->boolean('overlap_ok')->default(false);

            $t->timestamps();
        });
    }
    public function down(): void {
        Schema::dropIfExists('leave_mission_details');
    }
};
