<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('approval_steps', function (Blueprint $t) {
            $t->id();
            $t->foreignId('request_id')->constrained('leave_mission_requests')->cascadeOnDelete();
            $t->unsignedTinyInteger('step_order'); // 1,2,3...
            $t->foreignId('approver_id')->constrained('users')->cascadeOnDelete();
            $t->string('role_hint',50)->nullable();
            $t->enum('status', ['pending','approved','rejected','skipped'])->default('pending');
            $t->timestamp('decided_at')->nullable();
            $t->foreignId('delegated_to')->nullable()->constrained('users')->nullOnDelete();
            $t->text('comment')->nullable();
            $t->timestamps();

            $t->unique(['request_id','step_order']);
            $t->index(['approver_id','status']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('approval_steps');
    }
};
