
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('leave_mission_requests', function (Blueprint $table) {
            if (!Schema::hasColumn('leave_mission_requests','project_id')) {
                $table->foreignId('project_id')->nullable()->constrained()->nullOnDelete();
                $table->index(['project_id','type']);
            }
        });
    }

    public function down(): void
    {
        Schema::table('leave_mission_requests', function (Blueprint $table) {
            if (Schema::hasColumn('leave_mission_requests','project_id')) {
                $table->dropConstrainedForeignId('project_id');
            }
        });
    }
};
