<?php
// database/migrations/2025_01_01_000010_upgrade_approval_steps_add_decision_columns.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('approval_steps', function (Blueprint $table) {
            if (!Schema::hasColumn('approval_steps', 'decided_at')) {
                $table->timestamp('decided_at')->nullable()->after('status');
            }
            if (!Schema::hasColumn('approval_steps', 'decided_by')) {
                // اگر users ندارید، constrained رو بردارید
                $table->foreignId('decided_by')->nullable()->constrained('users')->nullOnDelete();
            }
            if (!Schema::hasColumn('approval_steps', 'decision_note')) {
                // بدون after تا به ستون قبلی وابسته نشه
                $table->text('decision_note')->nullable();
            }
        });
    }

    public function down(): void {
        Schema::table('approval_steps', function (Blueprint $table) {
            if (Schema::hasColumn('approval_steps', 'decision_note')) {
                $table->dropColumn('decision_note');
            }
            if (Schema::hasColumn('approval_steps', 'decided_by')) {
                $table->dropConstrainedForeignId('decided_by'); // لاراول 9+
                // برای نسخه‌های قدیمی‌تر:
                // $table->dropForeign(['decided_by']);
                // $table->dropColumn('decided_by');
            }
            if (Schema::hasColumn('approval_steps', 'decided_at')) {
                $table->dropColumn('decided_at');
            }
        });
    }
};
