<?php
// database/migrations/2025_01_01_000002_add_project_id_to_leave_mission_details.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('leave_mission_details', function (Blueprint $table) {
            if (!Schema::hasColumn('leave_mission_details','project_id')) {
                $table->unsignedBigInteger('project_id')->nullable()->after('mission_purpose');
                $table->foreign('project_id')->references('id')->on('projects')->nullOnDelete();
            }
            if (Schema::hasColumn('leave_mission_details','mission_address')) {
                $table->dropColumn('mission_address'); // طبق تصمیم شما حذف آدرس
            }
        });
    }
    public function down(): void {
        Schema::table('leave_mission_details', function (Blueprint $table) {
            if (!Schema::hasColumn('leave_mission_details','mission_address')) {
                $table->string('mission_address')->nullable();
            }
            if (Schema::hasColumn('leave_mission_details','project_id')) {
                $table->dropConstrainedForeignId('project_id');
            }
        });
    }
};
