<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('attendance_approval_rules', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // نام قانون برای نمایش به مدیر
            $table->string('company_id')->nullable(); // اگر می‌خواهید قوانین را بر اساس شرکت فیلتر کنید
            $table->string('type')->nullable(); // 'leave' یا 'mission' یا null برای هر دو
            $table->string('leave_type')->nullable(); // 'annual', 'sick', ... فقط برای مرخصی
            $table->foreignId('project_id')->nullable()->constrained()->nullOnDelete(); // فقط برای ماموریت
            $table->foreignId('department_id')->nullable()->constrained()->nullOnDelete(); // اعمال قانون برای دپارتمان خاص
            $table->integer('min_duration_hours')->nullable(); // حداقل مدت (ساعت) برای اعمال قانون
            $table->integer('max_duration_hours')->nullable(); // حداکثر مدت (ساعت) برای اعمال قانون
            $table->integer('step_order')->default(1); // ترتیب اجرای قانون در زنجیره
            $table->json('approvers'); // لیستی از ID کاربران تأییدکننده (مثلاً: [1, 5, 12])
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('attendance_approval_rules');
    }
};
