<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('file_activities', function (Blueprint $table) {
            $table->id();

            // رابطه با فایل تغییر یافته
            $table->foreignId('project_file_id')
                ->constrained('project_files')
                ->onDelete('cascade');

            // رابطه با کاربری که عملیات را انجام داده است
            $table->foreignId('user_id')
                ->nullable()
                ->constrained('users')
                ->onDelete('set null');

            // نوع فعالیت: (UPLOAD, METADATA_EDIT, DELETE, DOWNLOAD)
            $table->string('action_type', 50)->index();

            // شرح جزئیات عملیات (مثلاً: تغییر نام از X به Y)
            $table->text('details')->nullable();

            // ذخیره مقادیر قدیمی و جدید (اختیاری برای گزارش‌گیری دقیق)
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('file_activities');
    }
};
