<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('permissions', function (Blueprint $table) {
            // ستون 'label' برای نام نمایشی و فارسی مجوز
            $table->string('label')->nullable()->after('name');

            // ستون 'group' برای گروه‌بندی مجوزها (مثل projects, finance, users)
            $table->string('group')->nullable()->after('label');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('permissions', function (Blueprint $table) {
            $table->dropColumn('group');
            $table->dropColumn('label');
        });
    }
};
