<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('project_contracts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->foreignId('status_id')->nullable()->constrained('contract_statuses')->onDelete('set null');

            $table->string('title');
            $table->string('number')->nullable();
            $table->text('description')->nullable();

            $table->decimal('base_amount', 20, 2)->default(0);
            $table->string('currency_unit')->default('IRR');
            $table->decimal('exchange_rate', 15, 6)->nullable();

            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->date('signed_at')->nullable();

            $table->string('contract_type')->default('main'); // main, supervision, consulting, etc.
            $table->boolean('is_main')->default(false);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('project_contracts');
    }
};
