<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('project_contract_addenda', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_contract_id')->constrained()->onDelete('cascade');

            $table->string('title');
            $table->text('description')->nullable();
            $table->decimal('amount', 20, 2);
            $table->string('currency_unit')->default('IRR');
            $table->decimal('exchange_rate', 15, 6)->nullable();
            $table->date('effective_date')->nullable();
            $table->date('approved_at')->nullable();

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('project_contract_addenda');
    }
};
