<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('project_contract_documents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_contract_id')->constrained()->onDelete('cascade');
            $table->foreignId('uploaded_by')->constrained('users')->onDelete('set null');

            $table->string('title');
            $table->string('file_path');
            $table->string('version')->nullable();

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('project_contract_documents');
    }
};
