<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_login_histories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade'); // ارتباط با مدل User
            $table->timestamp('login_at'); // زمان ورود
            $table->string('ip_address', 45); // ذخیره IP (IPv6 تا 39 کاراکتر + ::1)
            $table->string('user_agent')->nullable(); // ممکنه برای شناسایی مک آدرس کاربرد داشته باشه، اما نه همیشه قابل اعتماد
            $table->string('mac_address', 17)->nullable(); // فرمت XX:XX:XX:XX:XX:XX (17 کاراکتر)
            $table->json('metadata')->nullable(); // فیلد اختیاری برای ذخیره اطلاعات اضافی (مثل نام دستگاه، سیستم عامل و ...)
            $table->timestamps(); // created_at و updated_at (که ممکنه با login_at یکی باشه)
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_login_histories');
    }
};
