<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('document_files', function (Blueprint $table) {
            $table->unsignedBigInteger('size')->nullable()->after('file_name');
            $table->string('mime_type')->nullable()->after('size');
            $table->string('checksum', 64)->nullable()->after('mime_type'); // SHA256 = 64 chars
        });
    }

    public function down()
    {
        Schema::table('document_files', function (Blueprint $table) {
            $table->dropColumn(['size', 'mime_type', 'checksum']);
        });
    }
};
