<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        // اول ایندکس قدیمی را حذف کن
        Schema::table('disciplines', function (Blueprint $table) {
            $table->dropUnique(['name']); // نام دقیق ایندکس ممکن است متفاوت باشد
        });

        // سپس ایندکس جدید را بر اساس name + project_id ایجاد کن
        Schema::table('disciplines', function (Blueprint $table) {
            $table->unique(['name', 'project_id'], 'disciplines_name_project_unique');
        });
    }

    public function down()
    {
        // بازگشت: ایندکس ترکیبی را حذف و دوباره فقط name را unique کن
        Schema::table('disciplines', function (Blueprint $table) {
            $table->dropUnique('disciplines_name_project_unique');
        });

        Schema::table('disciplines', function (Blueprint $table) {
            $table->unique('name');
        });
    }
};
