<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('document_revisions', function (Blueprint $table) {
            // حذف purpose_of_issue اگر نیاز نیست
            if (Schema::hasColumn('document_revisions', 'purpose_of_issue')) {
                $table->dropColumn('purpose_of_issue');
            }
            // اضافه کردن poi_type اگر وجود ندارد
            if (!Schema::hasColumn('document_revisions', 'poi_type')) {
                $table->string('poi_type')->nullable()->after('remark');
            }
        });
    }

    public function down()
    {
        Schema::table('document_revisions', function (Blueprint $table) {
            $table->dropColumn('poi_type');
            // اگر بخواهید purpose_of_issue را برگردانید:
            // $table->string('purpose_of_issue')->nullable();
        });
    }
};
