<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */

    public function up()
    {
        Schema::create('project_poi_weights', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->string('poi_type'); // مثلاً IFC, IFA, ...
            $table->decimal('weight_percent', 5, 2)->default(0); // حداکثر 100.00%
            $table->unique(['project_id', 'poi_type']);
            $table->timestamps(); // این دو ستون را ایجاد می‌کند: created_at, updated_at

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_poi_weights');
    }
};
