<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users'); // درخواست دهنده
            $table->foreignId('purchase_request_id')->nullable()->constrained('purchase_requests'); // مرجع درخواست خرید
            $table->foreignId('project_id')->constrained('projects');
            $table->string('recipient_name'); // نام دریافت کننده وجه/چک
            $table->decimal('amount', 15, 2); // مبلغ مورد درخواست
            $table->text('purpose'); // شرح هدف پرداخت
            $table->enum('status', ['pending', 'approved', 'rejected', 'paid'])->default('pending');
            $table->date('due_date')->nullable(); // تاریخ سررسید مورد نظر
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_requests');
    }
};
