<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. به‌روزرسانی جدول PurchaseRequest (جدول اصلی درخواست)
        Schema::table('purchase_requests', function (Blueprint $table) {
            // فیلدهای اضافه شده در Livewire
            $table->enum('purchase_type', ['material', 'service', 'asset'])->after('project_id')->default('material');
            $table->unsignedBigInteger('cost_center_id')->after('purchase_type')->nullable(); // فرض می‌کنیم جدول cost_centers وجود دارد
            $table->date('required_by')->after('description')->nullable();

            // افزودن محدودیت‌های خارجی (Foreign Key)
            // اگر جدول cost_centers دارید
            // $table->foreign('cost_center_id')->references('id')->on('cost_centers')->onDelete('set null');
        });

        // 2. به‌روزرسانی جدول purchase_request_items (جدول آیتم‌ها)
        Schema::table('purchase_request_items', function (Blueprint $table) {
            // اجازه دادن به item_id برای خدمات آزاد
            $table->unsignedBigInteger('item_id')->nullable()->change();

            // فیلد برای ذخیره شرح خدمات (در صورتیکه item_id = null باشد)
            $table->text('description')->after('price')->nullable();

            // اگر از این مدل به عنوان جدول میانی (Pivot) استفاده می‌کنید:
            // اگر قبلا primary key تعریف نشده، آن را تعریف کنید
            // $table->id()->first();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            // $table->dropForeign(['cost_center_id']); // در صورت وجود
            $table->dropColumn(['purchase_type', 'cost_center_id', 'required_by']);
        });

        Schema::table('purchase_request_items', function (Blueprint $table) {
            // بازگرداندن item_id به حالت not nullable (اگر قبلا اینطور بوده)
            // $table->unsignedBigInteger('item_id')->nullable(false)->change();
            $table->dropColumn('description');
        });
    }
};
