<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payees', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['person', 'company']); // شخص حقیقی یا حقوقی
            $table->string('name'); // نام کامل شخص یا شرکت
            $table->string('national_id')->unique()->nullable(); // کد ملی یا شناسه ملی

            // اطلاعات بانکی
            $table->string('bank_name')->nullable();
            $table->string('account_number')->nullable();
            $table->string('sheba')->nullable();

            $table->string('contact_person')->nullable(); // فقط برای شرکت‌ها
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payees');
    }
};
