<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 💡 فرض می‌کنیم جدول payees قبلاً ایجاد شده است (به دلیل خطای قبلی شما)
        Schema::table('payment_requests', function (Blueprint $table) {

            // --- لینک به ذینفع (Payee) ---
            // این ستون حیاتی را که مدل PaymentRequest به آن نیاز دارد، اضافه می‌کنیم.
            $table->foreignId('payee_id')->after('project_id')->nullable()->constrained('payees');

            // --- فیلدهای مالیات و ناخالص ---
            $table->decimal('amount_gross', 15, 2)->after('amount')->nullable();
            $table->decimal('tax_amount', 15, 2)->after('amount_gross')->default(0);

            // اگر purchase_request_id هم در تصویر نبود، این را هم اضافه کنید
            if (!Schema::hasColumn('payment_requests', 'purchase_request_id')) {
                $table->foreignId('purchase_request_id')->after('user_id')->nullable()->constrained('purchase_requests');
            }
        });
    }

    public function down(): void
    {
        Schema::table('payment_requests', function (Blueprint $table) {
            $table->dropConstrainedForeignId('payee_id');
            $table->dropColumn(['amount_gross', 'tax_amount']);

            if (Schema::hasColumn('payment_requests', 'purchase_request_id')) {
                $table->dropConstrainedForeignId('purchase_request_id');
            }
        });
    }
};
