<?php
// database/migrations/..._add_type_to_approval_rules_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('approval_rules', function (Blueprint $table) {
            // 💡 اضافه کردن فیلد 'type' با مقادیر مجاز 'purchase' یا 'payment'
            $table->enum('type', ['purchase', 'payment'])->default('purchase')->after('project_id');
        });
    }

    public function down(): void
    {
        Schema::table('approval_rules', function (Blueprint $table) {
            $table->dropColumn('type');
        });
    }
};
