<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('sales_invoices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('project_id')->constrained('projects');

            $table->string('invoice_number')->unique();
            $table->string('client_name');

            $table->date('issue_date');
            $table->date('due_date');

            // مبالغ مالی
            $table->decimal('net_amount', 15, 2); // خالص (قبل از مالیات)
            $table->decimal('tax_amount', 15, 2)->default(0);
            $table->decimal('total_amount', 15, 2); // نهایی (شامل مالیات)

            $table->text('description')->nullable();
            $table->enum('status', ['issued', 'paid', 'canceled'])->default('issued');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('sales_invoices');
    }
};
