<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sales_invoices', function (Blueprint $table) {

            // 💡 ستون‌های مدیریت ارز
            $table->string('currency', 10)->after('client_name')->default('IRR')->comment('واحد پول فاکتور (IRR, USD, EUR)');
            $table->decimal('exchange_rate', 15, 4)->after('currency')->default(1.0)->comment('نرخ تبدیل هر واحد ارز به ریال در زمان صدور');

            // 💡 تغییر نام ستون total_amount به total_foreign (مبلغ خارجی)
            // اگر ستون total_amount را قبلا ساخته‌اید، باید آن را به total_foreign تغییر نام دهید
            // یا مستقیماً در مدل استفاده کنید.
            // فرض می‌کنیم ستون‌های مالی زیر نیاز به تغییر دارند:
            $table->renameColumn('total_amount', 'total_foreign');

            $table->decimal('total_amount_irr', 15, 0)->after('total_foreign')->nullable()->comment('مبلغ نهایی معادل ریالی');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sales_invoices', function (Blueprint $table) {
            //
        });
    }
};
