<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('sales_invoices', function (Blueprint $table) {

            // 💡 1. ستون‌های مدیریت ارز (ADD ONLY)
            // این ستون‌ها باید اضافه شوند:
            if (!Schema::hasColumn('sales_invoices', 'currency')) {
                $table->string('currency', 10)->after('client_name')->default('IRR')->comment('واحد پول فاکتور (IRR, USD, EUR)');
                $table->decimal('exchange_rate', 15, 4)->after('currency')->default(1.0)->comment('نرخ تبدیل');
            }

            // 💡 2. اضافه کردن ستون‌های مبلغ ارزی و ریالی (با فرض حذف total_amount)
            if (!Schema::hasColumn('sales_invoices', 'total_foreign')) {
                // نام ستون ارزی را مستقیماً اضافه می‌کنیم
                $table->decimal('total_foreign', 15, 2)->after('tax_amount')->nullable()->comment('مبلغ کل فاکتور بر حسب ارز خارجی');
            }
            if (!Schema::hasColumn('sales_invoices', 'total_amount_irr')) {
                // نام ستون ریالی نهایی را اضافه می‌کنیم
                $table->decimal('total_amount_irr', 15, 0)->after('total_foreign')->nullable()->comment('مبلغ نهایی معادل ریالی');
            }

            // 💡 3. اگر ستون total_amount به اشتباه وجود دارد و نیاز به حذف دارد:
            if (Schema::hasColumn('sales_invoices', 'total_amount')) {
                // اگر ستون total_amount وجود دارد، آن را حذف می‌کنیم. (این فقط برای تمیزکاری است)
                // $table->dropColumn('total_amount');
            }
        });
    }

    public function down(): void
    {
        Schema::table('sales_invoices', function (Blueprint $table) {
            $table->dropColumn(['currency', 'exchange_rate', 'total_amount_irr', 'total_foreign']);
            // 💡 در اینجا باید total_amount را برگردانید اگر قبلا آن را ساخته بودید.
            // $table->decimal('total_amount', 15, 2)->nullable();
        });
    }
};
