<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('letters', function (Blueprint $table) {

            // =============================== حذف فیلدهای تکراری و منسوخ ===============================

            // 1. حذف فیلد 'signed' (تکراری با 'signed_at')
            if (Schema::hasColumn('letters', 'signed')) {
                $table->dropColumn('signed');
            }

            // 2. حذف فیلد 'receiver_id' (چون از جدول واسط letter_user برای گیرندگان استفاده می‌شود)
            if (Schema::hasColumn('letters', 'receiver_id')) {
                $table->dropColumn('receiver_id');
            }

            // 3. حذف 'type' اگر تصمیم به استفاده انحصاری از 'priority' گرفته‌اید
            // if (Schema::hasColumn('letters', 'type')) {
            //     $table->dropColumn('type');
            // }

            // =============================== اضافه/تکمیل فیلدهای مدرن ===============================

            // فیلدهای جدید (اگر قبلا اضافه نشده بودند)
            if (!Schema::hasColumn('letters', 'priority')) {
                $table->enum('priority', ['low', 'normal', 'high', 'urgent'])->default('normal')->after('status');
            }
            if (!Schema::hasColumn('letters', 'confidential')) {
                $table->boolean('confidential')->default(false)->after('priority');
            }
            if (!Schema::hasColumn('letters', 'pdf_path')) {
                $table->string('pdf_path')->nullable()->after('signed_at');
            }

            // تکمیل فیلد unique_code (اگر فقط در متد sign استفاده می‌شد و در جدول نبود)
            if (!Schema::hasColumn('letters', 'unique_code')) {
                $table->uuid('unique_code')->nullable()->unique()->after('code');
            }
        });

        // جدول letter_copies (برای رونوشت‌ها - ضروری برای Livewire کامپوننت)
        if (!Schema::hasTable('letter_copies')) {
            Schema::create('letter_copies', function (Blueprint $table) {
                $table->id();
                $table->foreignId('letter_id')->constrained()->cascadeOnDelete();
                $table->string('name');
                $table->string('position')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('letters', function (Blueprint $table) {
            // حذف فیلدهای اضافه شده در up
            if (Schema::hasColumn('letters', 'priority')) $table->dropColumn('priority');
            if (Schema::hasColumn('letters', 'confidential')) $table->dropColumn('confidential');
            if (Schema::hasColumn('letters', 'pdf_path')) $table->dropColumn('pdf_path');
            if (Schema::hasColumn('letters', 'unique_code')) $table->dropColumn('unique_code');

            // بازگرداندن فیلدهای حذف شده (اختیاری: فقط در صورت لزوم)
            // $table->boolean('signed')->nullable();
            // $table->foreignId('receiver_id')->nullable()->constrained('users');
            // $table->string('type')->nullable();
        });

        Schema::dropIfExists('letter_copies');
    }
};
