<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('letters', function (Blueprint $table) {
            // ستون‌هایی که در مدل وجود دارند ولی در دیتابیس نیستند
            if (!Schema::hasColumn('letters', 'from_who')) {
                $table->string('from_who')->nullable();
            }
            if (!Schema::hasColumn('letters', 'from_where')) {
                $table->string('from_where')->nullable();
            }
            if (!Schema::hasColumn('letters', 'due_date')) {
                $table->date('due_date')->nullable();
            }
            if (!Schema::hasColumn('letters', 'signature_position')) {
                $table->string('signature_position')->nullable();
            }
        });
    }

    public function down()
    {
        Schema::table('letters', function (Blueprint $table) {
            $table->dropColumn(['from_who', 'from_where', 'due_date', 'signature_position']);
        });
    }
};
