<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * اجرای مایگریشن‌ها
     */
    public function up(): void
    {
        Schema::table('letters', function (Blueprint $table) {
            // فیلدهای مرجع خارجی
            $table->string('external_sender')->nullable()->after('signature_position');
            $table->string('external_number')->nullable()->after('external_sender');
            $table->date('external_date')->nullable()->after('external_number');

            // فیلد گیرنده داخلی نامه وارده (مسئول اولیه)
            $table->unsignedBigInteger('recipient_user_id')->nullable()->after('user_id');

            // ایندکس‌ها
            $table->index('external_number');
            $table->foreign('recipient_user_id')
                ->references('id')
                ->on('users')
                ->onDelete('set null');
        });
    }

    /**
     * بازگرداندن مایگریشن‌ها
     */
    public function down(): void
    {
        Schema::table('letters', function (Blueprint $table) {
            // حذف کلید خارجی و ایندکس
            $table->dropForeign(['recipient_user_id']);
            $table->dropIndex(['external_number']);

            // حذف ستون‌ها
            $table->dropColumn('recipient_user_id');
            $table->dropColumn('external_sender');
            $table->dropColumn('external_number');
            $table->dropColumn('external_date');
        });
    }
};
