<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('petty_cash_approvals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('petty_cash_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->text('comments')->nullable();
            $table->timestamp('approved_at')->nullable();
            $table->timestamps();

            // یک کاربر فقط یک بار می‌تواند یک درخواست را تأیید/رد کند
            $table->unique(['petty_cash_id', 'user_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('petty_cash_approvals');
    }
};
