<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('petty_cash_project', function (Blueprint $table) {
            $table->id();
            $table->foreignId('petty_cash_id')->constrained()->onDelete('cascade');
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->timestamps();

            $table->unique(['petty_cash_id', 'project_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('petty_cash_project');
    }
};
