<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('letter_templates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade'); // خالق قالب
            $table->string('name', 150)->unique();
            $table->string('code', 20)->unique()->nullable();
            $table->text('content'); // محتوای اصلی قالب (HTML از TinyMCE)
            $table->string('type', 50)->default('Formal'); // نوع قالب: معرفی نامه، داخلی، قرارداد و غیره
            $table->string('description', 500)->nullable();
            $table->boolean('is_public')->default(true); // عمومی (قابل استفاده برای همه) یا خصوصی (فقط برای خالق)
            $table->timestamps();

            $table->index('code');
            $table->index('is_public');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('letter_templates');
    }
};
